Include([[Data/levels/include/level_utils.lua]])
Include([[Data/levels/include/general_utils.lua]])

Level =
{
	MapSkinFilename = [[jungle.lua]],
	MapGenScript = LevelUtils.MapGenFromSVG([[mission7.svg]]),
	Parameters =
	{
		MarineCount 		= 5,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 0.0,
		PointGainPerCapture = 4,
		StartBuildPoints    = 20
	},
	Rules = 
	{
		AutoCapture 	= false,		--Destroying hives automatically counts as a capture
		NoPushback		= false,		--Can the player's points be captured?
		NoTowerRespawn  = false,        --Can the hive towers respawn?
		WeakenHiveOnCap = true,         --Do captures halve defensive strength?
		DisableLockdown = false,        --Turn off emergency help is player is behind
		NoAdvance       = false,        --Do not allow player to capture points
		HiveCtrAttack   = false,        --Send alien spawn to undefended alien hives
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 0,
		Default = [[disabled]],
		Active =
		{
		},
		Queue =
		{
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		--Default = [[inactive]],
		--FreeUpgradesDefault = [[active]],
		Active =
		{
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	},
	
	GetLevelProgress = function ()
        local progress = math.max((numHumanCaptures / totalCrates) * 0.7,  (CaptureTrigger.capture_counter / totalCapPoints)) 
		return progress
	end,
	
	OnDebugCall = function (mousePos)
        CreatePunitiveStrikeSquad()
	end
}

samplePathMarkerHdl = nil

totalCrates = 0
totalCapPoints = 0

------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)		

        local entCount = GameWorld:GetEntityCount()
        for i=0,entCount-1 do
            local ent = GameWorld:GetEntityByIndex(i)
            
            if ent then
                local crate = ent:ToCPropCrate()
                if crate then
                    crate:SetActivation(true)
                    crate:SetCrateDrag(0.6)
                    table.insert(cratesList, crate:GetHandle())
                    
                    crateInterceptTeamList[crate:GetId()] = {}
					totalCrates = totalCrates + 1
                end
				
				local capPt = ent:ToCCapturePoint()
				if capPt and not capPt:IsLocked() then
					totalCapPoints = totalCapPoints + 1
				end
            end
        end
            
        GameWorld:SetSpawnRate(globalSpawnRate)
        GameWorld:SetSpawnRateScalingOn(false)
            
        GameWorld:SetEntityVisible("crateDest0", true)
		GameWorld:CreateTrainingArrow("crateDest0")
		
		local startEnt = GameWorld:GetEntityById("sampleBox")
		local endEnt = GameWorld:GetEntityById("crateDest0")
		
		samplePathMarkerHdl = GameWorld:CreatePathMarker(startEnt:GetPos(), endEnt:GetPos()):GetHandle()  
            
        LevelUtils.ShowTimedDialogue("Commander, we need to gather these crates\n\nBring them over to my location", "Scout")
        
        GameWorld:CreateTrainingArrow("doctor",     "PNT_PORTRAIT_SCOUT")
        
        GameWorld:AddObjective("crateObj", "Tow crates to Doctor for BP")
        CaptureAllGoal:Enable()
        LossCondition:Enable()
        
        
		self:Disable()
	end)
LevelInit:Enable()

cratesList = {}
crateInterceptTeamList = {}
crateObjComplete = false

function PropCrateUpdateScript(p_milliseconds)
    
    filter_inplace(cratesList, function(p_handle) return p_handle and p_handle:GetPtr() ~= nil end)
    
    local destEnt = GameWorld:GetEntityById("crateDest0")
    if not destEnt then
        return
    end
    
    local destEnt2 = GameWorld:GetEntityById("crateDest1")
    if not destEnt2 then
        return
    end
    
    for i=1,#cratesList do
    
        local crateEnt = cratesList[i]:GetPtr()
        if crateEnt then   
            crateEnt = crateEnt:ToCPropCrate()
            if crateEnt then
            
            	filter_inplace(crateInterceptTeamList[crateEnt:GetId()],
            		function(p_handle) return p_handle and p_handle:GetPtr() ~= nil end)
            	
            
                local crateAttached = crateEnt:GetAttachedActivator() ~= nil
                
                if crateAttached and vect2f.IsDistLess(crateEnt:GetPos(), destEnt:GetPos(), 10.0) then
                    GameWorld:AwardBuildPoints(4, crateEnt:GetPos())
                    
                    crateEnt:DetachActivator()
                    crateEnt:SetActivation(false)
                    --cratesList[i] = nil
                    
                    crateEnt:Kill()
                    
                    OnHumanCapture()
                end
                
                if crateAttached and vect2f.IsDistLess(crateEnt:GetPos(), destEnt2:GetPos(), 10.0) then
                    
                    crateEnt:DetachActivator()
                    crateEnt:SetActivation(false)
                    --cratesList[i] = nil
                    
                    crateEnt:Kill()
                    
                    OnAlienCapture()
                end
            end
        end
    end
    
    if #cratesList == 0 and crateObjComplete == false then
        GameWorld:ChangeObjectiveStatus("crateObj", [[complete]])
		crateObjComplete = true
    end
end
ScriptMgr:SetUpdateCallback(PropCrateUpdateScript)

----------------------------------------------------------------------------------------------

function CreateTeamObject(p_teamSize)

    local alienTeam = {}
    
    alienTeam.teamHandles = {}
    alienTeam.attackInProgress = false
    alienTeam.crateHandle = nil
    alienTeam.fullTeamSize = p_teamSize
    
    function alienTeam:Update()
        if #cratesList <= 0  then
            return
        end

        local teamLeaderDead = #self.teamHandles > 0 and (self.teamHandles[1]:GetPtr() == nil)
        if self.crateHandle ~= nil and self.teamHandles[1] then
            local entity = self.crateHandle:GetPtr()
            if entity then
                local crate = entity:ToCPropCrate()
                if crate then
                    local human = crate:GetAttachedActivator()
                    if human and human ~= self.teamHandles[1]:GetPtr() then
                        self.crateHandle = nil
                    end
                end
            end
        end

        if self.crateHandle and not self.crateHandle:GetPtr() then
            self.crateHandle = nil
        end

        filter_inplace(self.teamHandles, function(p_handle) return p_handle and p_handle:GetPtr() ~= nil end)
        
        if self.attackInProgress then
            if #self.teamHandles == 0 then --or self.teamHandles[1]:GetPtr():GetIsIdle() and not self.crateHandle  then
                self.attackInProgress = false
            elseif not self.crateHandle then
                self:DoAlienAttack(false)
            elseif teamLeaderDead then
                self:OrderStrikeToCrate(self.crateHandle)
            end            
        else
            self.crateHandle = nil
            self:DoAlienAttack(true)
            self.attackInProgress = true
        end
    end
    
    function alienTeam:AddTeamMember(p_marinePtr)
        for i=1,#self.teamHandles do
            local marine = self.teamHandles[i]:GetPtr()
            
            if marine then
                p_marinePtr:AddTeammate(marine)
                marine:AddTeammate(p_marinePtr)
            end
        end
    
        table.insert(self.teamHandles, p_marinePtr:GetHandle())
    end
    
    function alienTeam:GetMemberCount()
        return #self.teamHandles
    end
        
    local function OrderSingleMarineStrike(p_offset, p_marineHandle, p_targetHandle, p_grabCrate)

        local startEnt = GameWorld:GetEntityById("crateDest1")
        if startEnt == nil then
            return
        end

        local targetEnt = p_targetHandle:GetPtr()
        if targetEnt == nil then
            return
        end

        local marine = p_marineHandle:GetPtr()
        if marine == nil then
            return
        end
        
        if p_grabCrate then
            marine:SendCommand(ICommandable.CT_ATTACKMOVE, targetEnt:GetPos(), nil, false)
            marine:SendCommand(ICommandable.CT_ACTIVATE, targetEnt:GetPos(), targetEnt, false)
            marine:SendCommand(ICommandable.CT_ATTACKMOVE, startEnt:GetPos() + p_offset, nil, true)
            marine:SetSpeedMultiple(1.0)
        else
            marine:CommandProtect(targetEnt, p_offset)
            marine:SetSpeedMultiple(1.8)
            
            --marine:SendCommand(ICommandable.CT_ATTACKMOVE, targetEnt:GetPos() + p_offset, nil, false)
            --marine:SendCommand(ICommandable.CT_ATTACKMOVE, startEnt:GetPos() + p_offset, nil, true)    
        end

    end
    
    function alienTeam:OrderStrikeToCrate(p_crateHandle)
        for i=1,#self.teamHandles do
            --local offsetDelta = vect2f.MakePolar(GetRandomRangeInt(2.0, 3.0), i/#self.teamHandles*math.pi*2)
            local iEven = (i % 2 == 0)
            local length = (i - (i % 2)) / 2 - 0.5
            
            if not iEven then length = length * -1 end
            local offsetDelta = vect2f(GetRandomRange(0.0, 5.0), length * 3.5)
            
            if i==1 then
                OrderSingleMarineStrike(vect2f(0,0), self.teamHandles[i], p_crateHandle, true)
            else
                OrderSingleMarineStrike(offsetDelta, self.teamHandles[i], self.teamHandles[1], false)
            end
        end        
    end
    
    function alienTeam:CreateAlienMarine(p_offset)

        local startEnt = GameWorld:GetEntityById("crateDest1")
        if startEnt == nil then
            return
        end

        local marine = GameWorld:CreateEntity("InfestedMarine", "", startEnt:GetPos() + p_offset)
        --marine:SetPoisonResistance(10000)
        
        marine:SetDegeneration(false)

        local alienWeapons = {  [4] = WeaponType.WT_MEDIC,
                                [6] = WeaponType.WT_FUSIONRIFLE,
                                [7] = WeaponType.WT_FUSIONRIFLE,
                                [8] = WeaponType.WT_MEDIC,
                                [9] = WeaponType.WT_FUSIONRIFLE,
                                [10] = WeaponType.WT_FLAMETHROWER,
                                [11] = WeaponType.WT_SNIPERRIFLE   }
        local preferredWeapon = alienWeapons[#self.teamHandles+1]

        if preferredWeapon ~= nil then
            marine:SetWeaponType(preferredWeapon)
        end

        self:AddTeamMember(marine)

    end
    
    function alienTeam:DoAlienAttack(p_createTeam)

        local freeCrates = filter_copy(cratesList,
            function(p_handle)
                return p_handle and p_handle:GetPtr() ~= nil and not p_handle:GetPtr():ToCPropCrate():GetAttachedActivator()
            end)

		if #freeCrates <= 0 then
			return false
		end

        local crateIndex = GetRandomRangeInt(1.0, #freeCrates)
        local entireTeamDead = false
        if p_createTeam then
            if #self.teamHandles <= 0 and self.fullTeamSize < 11 then
                self.fullTeamSize = self.fullTeamSize + 1
    --        elseif #self.teamHandles >= self.fullTeamSize and self.fullTeamSize > 3 then
    --        	self.fullTeamSize = self.fullTeamSize - 1
            end

            local targetAlienCount = self.fullTeamSize
            local numAliensToCreate = targetAlienCount - #self.teamHandles
            for i=1,numAliensToCreate do
                local offsetDelta = vect2f.MakePolar(GetRandomRange(2.0, 5.0), #self.teamHandles/targetAlienCount*math.pi*2)
                
                self:CreateAlienMarine(offsetDelta)
            end
            
            entireTeamDead = (numAliensToCreate >= targetAlienCount)
        end
        
        self.crateHandle = freeCrates[crateIndex]
        --GameWorld:CreateTrainingArrow(self.crateHandle:GetPtr():GetId())
        
        if p_createTeam then
            local spawnTime = {[false] = 10000, [true] = 35000}
            
            ScriptMgr:DoDelayedCall(spawnTime[entireTeamDead],
                function()
                    if self.crateHandle and self.attackInProgress then
                        self:OrderStrikeToCrate(self.crateHandle)
                    end
                end)
        else
            self:OrderStrikeToCrate(self.crateHandle)
        end
            
        return true
    end
    
    return alienTeam

end

alienTeamList = {CreateTeamObject(4), CreateTeamObject(2)}

----------------------------------------------------------------------------------------------

function UpdateAlienTeam(p_milliseconds)

    for i=1,#alienTeamList do
        alienTeamList[i]:Update()
    end      
end
ScriptMgr:SetUpdateCallback(UpdateAlienTeam)

function CreatePunitiveStrikeSquad()

    local targetEnt = GameWorld:GetZombieAttackEntity()
    if targetEnt == nil then
        return
    end

    local startEnt = GameWorld:GetZombieAttackSpawnEntity(2, targetEnt:GetPos(), false) --GameWorld:GetEntityById("crateDest1")
    if startEnt == nil  then
        return
    end
    
    local alienCount = 3
    for i=1,alienCount do
        local offsetDelta = vect2f.MakePolar(GetRandomRange(3.0, 4.0), i/alienCount*math.pi*2)
        local marine = GameWorld:CreateEntity("InfestedMarine", "", startEnt:GetPos() + offsetDelta)
        
        marine:SendCommand(ICommandable.CT_ATTACKMOVE, targetEnt:GetPos() + offsetDelta, nil, true)
    end

end

globalSpawnRate = 3.0
spawnRateIncrement = 1.0

mutationIndex = 0
mutation_table = {}
mutation_table[1] = "ZU_SPIKE_POWER"
mutation_table[4] = "ZU_TOWER_CARAPACE" 
mutation_table[7] = "ZU_SPAWN_SPITTERS"
mutation_table[10] = "ZU_HIVE_SPIKES"
mutation_table[13] = "ZU_DEF_SPITTERS"
mutation_table[16] = "ZU_CLONES"
mutation_table[19] = "ZU_REGENERATION"
mutation_table[22] = "ZU_ZOMBIE_MINES"
mutation_table[25] = "ZU_MIMICRY"
mutation_table[28] = "ZU_HARDPOINT_MIMIC"
mutation_table[31] = "ZU_BONE_SHIELD"
mutation_table[34] = "ZU_NECROPHAGE"

function ApplyMutation(p_bumpCount)
    for i=1,p_bumpCount do
        mutationIndex = mutationIndex + 1
        local current_mutation = mutation_table[mutationIndex]
        if current_mutation then
            GameWorld:ActivateMutation(current_mutation, true)
        end
    end
end

numAlienCaptures = 0
local alienDialogueTriggered = false
function OnAlienCapture()
    CreatePunitiveStrikeSquad()
    
    globalSpawnRate = math.min(30.0, globalSpawnRate + spawnRateIncrement)
    GameWorld:SetSpawnRate(globalSpawnRate)
    
    GameWorld:MakeAnnouncement("Alien Crate\nCaptured");
    ApplyMutation(2)
    
    if not alienDialogueTriggered then
        LevelUtils.ShowTimedDialogue("They are using the pod resources to make more clones!\n\nGet ready to for attack!", "Scout")
        alienDialogueTriggered = true
    end
    
    for i=1,#alienTeamList do
        alienTeamList[i].fullTeamSize = math.max(3, alienTeamList[i].fullTeamSize - 2)
    end
    
    numAlienCaptures = numAlienCaptures + 1
end

numHumanCaptures = 0
function OnHumanCapture()
    numHumanCaptures = numHumanCaptures + 1

    globalSpawnRate = math.min(30.0, globalSpawnRate + spawnRateIncrement)
    GameWorld:SetSpawnRate(globalSpawnRate)
    
    GameWorld:RemoveTrainingArrow("crateDest0")
    local ent = samplePathMarkerHdl:GetPtr()
    if ent then
    	ent:Kill()
   	end
   	
   	TriggerDialogue()
   	
   	if numHumanCaptures == 10 then
   	    table.insert(alienTeamList, CreateTeamObject(2))
   	end
end


function TriggerDialogue()
    local dialogueIndex = numHumanCaptures    
    
    if      dialogueIndex == 1 then     LevelUtils.ShowTimedDialogue("Yes, the xenocide strain is still active\n\nI was worried it had degraded in these caves", "Scout")
    elseif  dialogueIndex == 6 then     LevelUtils.ShowTimedDialogue("Will this be enough bioweapon?\n\nWe need to keep gathering", "Scout")
    elseif  dialogueIndex == 11 then    LevelUtils.ShowTimedDialogue("There is a good chance that I can modify the strain to combat the clones", "Scout")
    elseif  dialogueIndex == 16 then    LevelUtils.ShowTimedDialogue("We will need to gather genetic material for this to work", "Scout")
    elseif  dialogueIndex == 21 then    LevelUtils.ShowTimedDialogue("I'm guessing that my bio-engineering PhD is about to become very useful", "Scout")
    elseif  dialogueIndex == 26 then    LevelUtils.ShowTimedDialogue("Great job collecting the bioweapons, Commander", "Scout")
    end
    
    dialogueIndex = dialogueIndex + 1
    
end

------------------------------------------------------------------------------- Capture Trigger
CaptureTrigger = LevelUtils.MakeGoal(
	function (self)
		self.capture_counter = 0
	end,
	
	{[[NT_CAPTURE_RECORD]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		
		self.capture_counter = self.capture_counter + 1
		
        globalSpawnRate = math.min(30.0, globalSpawnRate + spawnRateIncrement)
        GameWorld:SetSpawnRate(globalSpawnRate)        

        ApplyMutation(3)
      
	end)
CaptureTrigger:Enable()



------------------------------------------------------------------------------- Crate Counterattack Trigger
CrateCounterattackScript = LevelUtils.MakeGoal(
	function (self)
	end,
	
	{[[NT_POWERUP_TOWED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		
        local crate = GameWorld:GetEntityById(p_entId)
        if not crate then
            return
        end
        
        crate = crate:ToCPropCrate();
        if not crate then
            return
        end        
        
        local crateAttackList = crateInterceptTeamList[p_entId]
        local alienCount = 3 - #crateAttackList
        if alienCount <= 0 then
        	alienCount = 0
       	end
        
        local marine = crate:GetAttachedActivator()
        if not marine then
            return
        end  

        marine = marine:ToCHuman()
        if not marine or not marine:GetIsPlayerControlled() then
            return
        end
        
        local startEnt = GameWorld:GetZombieAttackSpawnEntity(2, marine:GetPos(), false)
        if startEnt == nil  then
            return
        end
        
       
        for i=1,alienCount do
            local offsetDelta = vect2f.MakePolar(GetRandomRange(3.0, 4.0), i/alienCount*math.pi*2)
            local alienMarine = GameWorld:CreateEntity("InfestedMarine", "", startEnt:GetPos() + offsetDelta)
            alienMarine:SetSpeedMultiple(2.0)
            alienMarine:SetDegeneration(false)
            
            table.insert(crateAttackList, alienMarine:GetHandle())
        end
     
        for i=1,#crateAttackList do
        	local handle = crateAttackList[i]
        	local entity = handle:GetPtr()
        	
        	if entity then
        		local alienMarine = entity:ToCHuman()
        		
        		if alienMarine then
        			alienMarine:CommandFocusAttack(marine, marine:GetPos())
        		end
        	end
        end
        	
      
	end)
CrateCounterattackScript:Enable()


------------------------------------------------------------------------------- Victory Condition - Capture All Points (short-circuit)
CaptureAllGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:AddObjective("winObj", "Capture all the enemy points")
	end,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[complete]])
		
		GameWorld:ClearText()
		GameWorld:GameOver(true)
		
		self:Disable()
	end) 

------------------------------------------------------------------------------- Lost all points
LossCondition = LevelUtils.MakeGoal(
	function (self)	
	end,
	
	{[[NT_ALL_POINTS_LOST]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[failed]])
	
		GameWorld:ClearText()
		GameWorld:GameOver(false)
	
		CaptureAllGoal:Disable()
	
		self:Disable()
	end)

------------------------------------------------------------------------------- Extra Win Achievement
LevelUtils.MakeGoal(
	function (self)
	end,
	
	{[[NT_GAME_OVER]]},
	function (self, p_type, p_entId, p_pos, p_other)
        if p_other == "win" and numAlienCaptures <= 0 then
		    SteamAchievements:SetAchievement("BEAT_TENSION_EXTRA_NOLOSS")
		end	
	end):Enable()